//  2011 IDesign Inc.
// Pytania? Komentarze? Odwied
// http://www.idesign.net

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Reflection;

namespace ServiceModelEx
{
   partial class AboutBox : Form
   {
      public AboutBox()
      {
         InitializeComponent();
      }

      #region Assembly Attibute Accessors

      public string AssemblyTitle
      {
         get
         {
            // Odczytuje wszystkie atrybuty Title dla tego podzespou
            object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyTitleAttribute),false);
            // Jeli istnieje przynajmniej jeden atrybut Title
            if(attributes.Length > 0)
            {
               // Wybiera pierwszy atrybut
               AssemblyTitleAttribute titleAttribute = (AssemblyTitleAttribute)attributes[0];
               // Jeli to nie jest pusty acuch, zwraca ten atrybut
               if(titleAttribute.Title != "")
                  return titleAttribute.Title;
            }
            // Jeli nie istnieje aden atrybut Title lub jeli atrybut Title ma posta pustego acucha, zwraca nazw pliku .exe
            return System.IO.Path.GetFileNameWithoutExtension(Assembly.GetExecutingAssembly().CodeBase);
         }
      }

      public string AssemblyVersion
      {
         get
         {
            return Assembly.GetExecutingAssembly().GetName().Version.ToString();
         }
      }

      public string AssemblyDescription
      {
         get
         {
            // Odczytuje wszystkie atrybuty Description dla tego podzespou
            object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyDescriptionAttribute),false);
            // Jeli nie istniej adne atrybuty Description, zwraca pusty acuch
            if(attributes.Length == 0)
               return "";
            // Jeli istnieje przynajmniej jeden atrybut Description, zwraca jego warto
            return ((AssemblyDescriptionAttribute)attributes[0]).Description;
         }
      }

      public string AssemblyProduct
      {
         get
         {
            // Odczytuje wszystkie atrybuty Product dla tego podzespou
            object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyProductAttribute),false);
            // Jeli nie istniej adne atrybuty Product, zwraca pusty acuch
            if(attributes.Length == 0)
               return "";
            // Jeli istnieje przynajmniej jeden atrybut Product, zwraca jego warto
            return ((AssemblyProductAttribute)attributes[0]).Product;
         }
      }

      public string AssemblyCopyright
      {
         get
         {
            // Odczytuje wszystkie atrybuty Copyright dla tego podzespou
            object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCopyrightAttribute),false);
            // Jeli nie istniej adne atrybuty Copyright, zwraca pusty acuch
            if(attributes.Length == 0)
               return "";
            // Jeli istnieje przynajmniej jeden atrybut Copyright, zwraca jego warto
            return ((AssemblyCopyrightAttribute)attributes[0]).Copyright;
         }
      }

      public string AssemblyCompany
      {
         get
         {
            // Odczytuje wszystkie atrybuty Company dla tego podzespou
            object[] attributes = Assembly.GetExecutingAssembly().GetCustomAttributes(typeof(AssemblyCompanyAttribute),false);
            // Jeli nie istniej adne atrybuty Company, zwraca pusty acuch
            if(attributes.Length == 0)
               return "";
            // Jeli istnieje przynajmniej jeden atrybut Company, zwraca jego warto
            return ((AssemblyCompanyAttribute)attributes[0]).Company;
         }
      }
      #endregion

      void OnOK(object sender,EventArgs e)
      {
         Close();
      }

      private void addressLabel_LinkClicked(object sender,LinkLabelLinkClickedEventArgs e)
      {
         m_LinkLabel.LinkVisited = true;
         System.Diagnostics.Process.Start("http://www.idesign.net");
      }
   }
}
